/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.common.entities.puffbug;

import com.google.common.collect.Lists;
import com.minecraftabnormals.abnormals_core.core.endimator.ControlledEndimation;
import com.minecraftabnormals.abnormals_core.core.endimator.Endimation;
import com.minecraftabnormals.abnormals_core.core.endimator.entity.IEndimatedEntity;
import com.minecraftabnormals.abnormals_core.core.util.MathUtil;
import com.minecraftabnormals.abnormals_core.core.util.NetworkUtil;
import com.minecraftabnormals.endergetic.api.entity.pathfinding.EndergeticFlyingPathNavigator;
import com.minecraftabnormals.endergetic.api.entity.util.RayTraceHelper;
import com.minecraftabnormals.endergetic.api.util.GenerationUtils;
import com.minecraftabnormals.endergetic.client.particles.EEParticles;
import com.minecraftabnormals.endergetic.common.blocks.poise.BolloomBudBlock;
import com.minecraftabnormals.endergetic.common.entities.booflo.BoofloEntity;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugAttachToHiveGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugAttackGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugBoostGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugCreateItemGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugDescentGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugPollinateGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugPullOutGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugRestOnHiveGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugRotateToFireGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugTargetAggressorGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugTeleportToBudGoal;
import com.minecraftabnormals.endergetic.common.entities.puffbug.ai.PuffBugTeleportToRestGoal;
import com.minecraftabnormals.endergetic.common.network.entity.puffbug.RotateMessage;
import com.minecraftabnormals.endergetic.common.tileentities.BolloomBudTileEntity;
import com.minecraftabnormals.endergetic.common.tileentities.PuffBugHiveTileEntity;
import com.minecraftabnormals.endergetic.core.EndergeticExpansion;
import com.minecraftabnormals.endergetic.core.registry.EEBlocks;
import com.minecraftabnormals.endergetic.core.registry.EEEntities;
import com.minecraftabnormals.endergetic.core.registry.EEItems;
import com.minecraftabnormals.endergetic.core.registry.EESounds;
import com.minecraftabnormals.endergetic.core.registry.other.EEDataSerializers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class PuffBugEntity
extends AnimalEntity
implements IEndimatedEntity {
    public static final Predicate<LivingEntity> CAN_ANGER = entity -> {
        if (entity instanceof PlayerEntity) {
            return entity.func_70089_S() && !entity.func_175149_v() && !((PlayerEntity)entity).func_184812_l_();
        }
        return !(entity instanceof PuffBugEntity) && entity.func_70089_S() && !entity.func_175149_v() && !entity.func_82150_aj();
    };
    public static final float SEEKING_FACTOR = 1.1f;
    public static final EntitySize PROJECTILE_SIZE = EntitySize.func_220311_c((float)0.5f, (float)0.5f);
    public static final EntitySize PROJECTILE_SIZE_CHILD = EntitySize.func_220311_c((float)0.26325f, (float)0.26325f);
    private static final DataParameter<Optional<BlockPos>> HIVE_POS = EntityDataManager.func_187226_a(PuffBugEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Direction> ATTACHED_HIVE_SIDE = EntityDataManager.func_187226_a(PuffBugEntity.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Optional<Vector3d>> LAUNCH_DIRECTION = EntityDataManager.func_187226_a(PuffBugEntity.class, EEDataSerializers.OPTIONAL_VEC3D);
    private static final DataParameter<Optional<Vector3d>> FIRE_DIRECTION = EntityDataManager.func_187226_a(PuffBugEntity.class, EEDataSerializers.OPTIONAL_VEC3D);
    private static final DataParameter<Boolean> FROM_BOTTLE = EntityDataManager.func_187226_a(PuffBugEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> INFLATED = EntityDataManager.func_187226_a(PuffBugEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> BOOSTING = EntityDataManager.func_187226_a(PuffBugEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(PuffBugEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final Endimation CLAIM_HIVE_ANIMATION = new Endimation(20);
    public static final Endimation PUFF_ANIMATION = new Endimation(20);
    public static final Endimation TELEPORT_TO_ANIMATION = new Endimation(15);
    public static final Endimation TELEPORT_FROM_ANIMATION = new Endimation(10);
    public static final Endimation ROTATE_ANIMATION = new Endimation(20);
    public static final Endimation POLLINATE_ANIMATION = new Endimation(120);
    public static final Endimation MAKE_ITEM_ANIMATION = new Endimation(100);
    public static final Endimation FLY_ANIMATION = new Endimation(25);
    public static final Endimation LAND_ANIMATION = new Endimation(20);
    public static final Endimation PULL_ANIMATION = new Endimation(25);
    public final ControlledEndimation HIVE_LANDING = new ControlledEndimation(20, 0);
    public final ControlledEndimation HIVE_SLEEP = new ControlledEndimation(25, 0);
    private TeleportController teleportController;
    private RotationController rotationController;
    private Endimation endimation = BLANK_ANIMATION;
    @Nullable
    private BlockPos budPos;
    @Nullable
    private BlockPos pollinationPos;
    @Nullable
    private Direction teleportHiveSide;
    @Nullable
    private Direction desiredHiveSide;
    @Nullable
    private ItemStack stackToCreate;
    @Nullable
    public BlockState stuckInBlockState;
    public boolean stuckInBlock;
    public float prevSpin;
    public float spin;
    private int animationTick;
    public int teleportCooldown;
    public int ticksAwayFromHive;
    public int puffCooldown;

    public PuffBugEntity(EntityType<? extends PuffBugEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new PuffBugMoveController(this);
        this.teleportController = new TeleportController(this);
        this.rotationController = new RotationController(this);
        this.field_70728_aV = 2;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HIVE_POS, Optional.empty());
        this.func_184212_Q().func_187214_a(ATTACHED_HIVE_SIDE, (Object)Direction.UP);
        this.func_184212_Q().func_187214_a(LAUNCH_DIRECTION, Optional.empty());
        this.func_184212_Q().func_187214_a(FIRE_DIRECTION, Optional.empty());
        this.func_184212_Q().func_187214_a(COLOR, (Object)-1);
        this.func_184212_Q().func_187214_a(FROM_BOTTLE, (Object)false);
        this.func_184212_Q().func_187214_a(INFLATED, (Object)true);
        this.func_184212_Q().func_187214_a(BOOSTING, (Object)false);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key.equals(FIRE_DIRECTION) || key.equals(LAUNCH_DIRECTION)) {
            this.func_213323_x_();
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PuffBugPullOutGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new PuffBugRestOnHiveGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PuffBugAttachToHiveGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PuffBugRotateToFireGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PuffBugCreateItemGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new PuffBugAttackGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new PuffBugTeleportToRestGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new PuffBugPollinateGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new PuffBugDescentGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new PuffBugTeleportToBudGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowParentGoal((AnimalEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(9, (Goal)new PuffBugBoostGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new PuffBugTargetAggressorGoal(this));
    }

    public void func_70071_h_() {
        if (this.stuckInBlock) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        if (this.func_184187_bx() instanceof BoofloEntity) {
            this.disableProjectile();
            this.removeLaunchDirection();
            this.setInflated(true);
        }
        super.func_70071_h_();
        this.endimateTick();
        this.getRotationController().tick();
        this.keepEffectsAbsorbed();
        this.field_70143_R = 0.0f;
        Vector3d motion = this.func_213322_ci();
        if (!this.field_70170_p.field_72995_K) {
            if (this.teleportCooldown > 0) {
                --this.teleportCooldown;
            }
            if (this.puffCooldown > 0) {
                --this.puffCooldown;
            }
            if (!this.func_184218_aH() && this.isInflated() && !this.getRotationController().rotating && this.isNoEndimationPlaying() && (this.isBoosting() && RayTraceHelper.rayTrace((Entity)this, 2.0, 1.0f).func_216346_c() != RayTraceResult.Type.BLOCK || (this.field_70122_E || this.func_70090_H()) && this.puffCooldown <= 0 && this.getPollinationPos() == null && this.getLaunchDirection() == null && this.getFireDirection() == null)) {
                NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)PUFF_ANIMATION);
                this.func_184185_a(this.getPuffSound(), 0.15f, this.func_70647_i());
            }
            if (this.isEndimationPlaying(TELEPORT_TO_ANIMATION) && this.getAnimationTick() == 10) {
                this.getTeleportController().bringToDestination();
            } else if (this.isEndimationPlaying(TELEPORT_FROM_ANIMATION)) {
                this.func_213317_d(Vector3d.field_186680_a);
            }
            if (this.getHivePos() == null) {
                Object hive;
                if (this.field_70170_p.func_82737_E() % 5L == 0L && this.func_70681_au().nextFloat() <= 0.1f && (hive = this.findNewNearbyHive()) != null) {
                    this.addToHive((PuffBugHiveTileEntity)((Object)hive));
                    if (this.isNoEndimationPlaying()) {
                        NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)CLAIM_HIVE_ANIMATION);
                    }
                }
                this.ticksAwayFromHive = 0;
            } else if (this.getHive() == null) {
                this.setHivePos(null);
            } else if (this.getAttachedHiveSide() == Direction.UP) {
                ++this.ticksAwayFromHive;
                if (this.ticksAwayFromHive < 1500 && this.func_70638_az() == null && this.func_70681_au().nextInt(7500) == 0 && !this.func_70880_s() && !this.getHive().isHiveFull()) {
                    for (PuffBugEntity nearbyHiveMembers : this.field_70170_p.func_175647_a(PuffBugEntity.class, this.func_174813_aQ().func_186662_g(9.0), puffbug -> puffbug.getHive() != null && puffbug.getHive() == this.getHive() && this.func_70032_d((Entity)puffbug) < 12.0f)) {
                        this.func_204700_e(1000);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
                        nearbyHiveMembers.func_204700_e(1000);
                        this.field_70170_p.func_72960_a((Entity)nearbyHiveMembers, (byte)18);
                        if (!this.func_70880_s() && !nearbyHiveMembers.func_70880_s()) continue;
                        break;
                    }
                }
            } else {
                this.ticksAwayFromHive = 0;
            }
            if (this.getAttachedHiveSide() != Direction.UP) {
                this.setInflated(false);
            } else if (!this.isInflated() && this.getFireDirection() == null) {
                this.setInflated(true);
            }
            if (this.func_70638_az() != null && !CAN_ANGER.test(this.func_70638_az())) {
                this.func_70624_b(null);
            }
            if (this.isProjectile() && (this.func_210500_b((ITag)FluidTags.field_206959_a, 1.0) || this.func_210500_b((ITag)FluidTags.field_206960_b, 1.0))) {
                this.disableProjectile();
            }
        } else {
            double z;
            double y;
            double x;
            double offsetZ;
            double offsetX;
            int i;
            this.prevSpin = this.spin;
            Random rand = this.func_70681_au();
            if (this.isEndimationPlaying(PUFF_ANIMATION) && this.getAnimationTick() == 5) {
                for (i = 0; i < 3; ++i) {
                    offsetX = MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.1f), (Random)rand);
                    offsetZ = MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.1f), (Random)rand);
                    x = this.func_226277_ct_() + offsetX;
                    y = this.func_226278_cu_() + (double)(rand.nextFloat() * 0.05f) + (double)0.7f;
                    z = this.func_226281_cx_() + offsetZ;
                    this.field_70170_p.func_195594_a((IParticleData)EEParticles.SHORT_POISE_BUBBLE.get(), x, y, z, MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.1f), (Random)rand) + (double)0.05f, (double)(rand.nextFloat() * 0.05f + 0.025f), MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.1f), (Random)rand) + (double)0.05f);
                }
            } else if (this.isEndimationPlaying(TELEPORT_TO_ANIMATION) && this.getAnimationTick() == 8) {
                for (i = 0; i < 6; ++i) {
                    offsetX = MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.1f), (Random)rand);
                    offsetZ = MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.1f), (Random)rand);
                    x = this.func_226277_ct_() + offsetX;
                    y = this.func_226278_cu_() + (double)(rand.nextFloat() * 0.05f) + (double)0.7f;
                    z = this.func_226281_cx_() + offsetZ;
                    this.field_70170_p.func_195594_a((IParticleData)EEParticles.SHORT_POISE_BUBBLE.get(), x, y, z, MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.15f), (Random)rand) + (double)0.025f, (double)(rand.nextFloat() * 0.025f + 0.025f), MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.15f), (Random)rand) + (double)0.025f);
                }
            } else if (this.isEndimationPlaying(TELEPORT_FROM_ANIMATION) && this.getAnimationTick() == 5) {
                for (i = 0; i < 6; ++i) {
                    offsetX = MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.1f), (Random)rand);
                    offsetZ = MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.1f), (Random)rand);
                    x = this.func_226277_ct_() + offsetX;
                    y = this.func_226278_cu_() + (double)(rand.nextFloat() * 0.05f) + (double)0.7f;
                    z = this.func_226281_cx_() + offsetZ;
                    this.field_70170_p.func_195594_a((IParticleData)EEParticles.SHORT_POISE_BUBBLE.get(), x, y, z, MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.15f), (Random)rand) + (double)0.025f, (double)(rand.nextFloat() * 0.025f + 0.025f), MathUtil.makeNegativeRandomly((double)(rand.nextFloat() * 0.15f), (Random)rand) + (double)0.025f);
                }
            }
            this.HIVE_LANDING.update();
            this.HIVE_SLEEP.update();
            this.HIVE_LANDING.tick();
            this.HIVE_SLEEP.tick();
            this.HIVE_LANDING.setDecrementing(this.getAttachedHiveSide() == Direction.UP);
            if (this.HIVE_LANDING.isAtMax()) {
                if (this.HIVE_SLEEP.isDecrementing() && this.HIVE_SLEEP.getTick() == 0) {
                    this.HIVE_SLEEP.setDecrementing(false);
                } else if (this.HIVE_SLEEP.isAtMax()) {
                    this.HIVE_SLEEP.setDecrementing(true);
                }
            } else {
                this.HIVE_SLEEP.setDecrementing(true);
            }
            this.spin = this.isProjectile() && this.isEndimationPlaying(FLY_ANIMATION) ? (this.spin += 55.0f) : 0.0f;
        }
        if (this.getDesiredHiveSide() != null && this.getHive() != null && this.getDesiredHiveSide() != Direction.DOWN) {
            float degrees;
            this.field_70177_z = this.field_70126_B = (degrees = (float)(this.getDesiredHiveSide() == Direction.SOUTH ? 0 : this.getDesiredHiveSide().func_176743_c().func_179524_a()) * (this.getDesiredHiveSide().func_176740_k() == Direction.Axis.Z ? 180.0f : -90.0f));
            this.field_70759_as = this.field_70758_at = degrees;
            this.field_70761_aq = this.field_70760_ar = degrees;
        }
        if (this.getAttachedHiveSide() != Direction.UP) {
            if (this.getHive() != null) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                this.func_70661_as().func_75499_g();
                this.func_70659_e(0.0f);
                this.func_70024_g(0.0, 0.0025f, 0.0);
                this.field_70177_z = this.field_70126_B;
                this.field_70759_as = this.field_70758_at;
                this.field_70761_aq = this.field_70760_ar;
                if (!this.field_70170_p.field_72995_K && !this.isAtCorrectRestLocation(this.getAttachedHiveSide())) {
                    this.setAttachedHiveSide(Direction.UP);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.setAttachedHiveSide(Direction.UP);
            }
        } else if (this.getLaunchDirection() != null || this.getFireDirection() != null) {
            this.field_70177_z = 0.0f;
            this.field_70759_as = 0.0f;
            this.field_70761_aq = 0.0f;
            Vector3d fireDirection = this.getFireDirection();
            if (fireDirection != null) {
                if (this.field_70170_p.field_72995_K && !this.stuckInBlock || !this.field_70170_p.field_72995_K) {
                    this.getRotationController().rotate((float)MathHelper.func_76138_g((double)(fireDirection.func_82617_b() - (double)this.field_70177_z)), (float)fireDirection.func_82615_a() + 90.0f, 0.0f, 5);
                }
                LivingEntity target = this.func_70638_az();
                if (!this.stuckInBlock) {
                    if (!this.field_70170_p.field_72995_K && target != null && this.isEndimationPlaying(FLY_ANIMATION)) {
                        float seekOffset = target.func_226278_cu_() > this.func_226278_cu_() ? 0.0f : 0.5f;
                        Vector3d targetVecNoScale = new Vector3d(target.func_226277_ct_() - this.func_226277_ct_(), target.func_226278_cu_() - (double)seekOffset - this.func_226278_cu_(), target.func_226281_cx_() - this.func_226281_cx_());
                        Vector3d targetVec = targetVecNoScale.func_186678_a((double)1.1f);
                        double motionLength = motion.func_72433_c();
                        double targetVecLength = targetVec.func_72433_c();
                        float totalVecLength = MathHelper.func_76133_a((double)(motionLength * motionLength + targetVecLength * targetVecLength));
                        Vector3d newMotion = motion.func_186678_a(motionLength / (double)totalVecLength).func_178787_e(targetVec.func_186678_a(targetVecLength / (double)totalVecLength));
                        float gravityCompensator = totalVecLength <= 4.0f ? 0.05f : 0.1f;
                        this.func_213317_d(newMotion.func_186678_a((double)0.4f).func_72441_c(0.0, (double)gravityCompensator, 0.0));
                    }
                    Vector3d newestMotion = this.func_213322_ci();
                    float pitch = -((float)(MathHelper.func_181159_b((double)newestMotion.func_82617_b(), (double)MathHelper.func_76133_a((double)(newestMotion.func_82615_a() * newestMotion.func_82615_a() + newestMotion.func_82616_c() * newestMotion.func_82616_c()))) * 57.2957763671875));
                    float yaw = (float)(MathHelper.func_181159_b((double)newestMotion.func_82616_c(), (double)newestMotion.func_82615_a()) * 57.2957763671875) - 90.0f;
                    this.setFireDirection(pitch, yaw);
                }
            }
        }
        if (this.isProjectile() && !this.isInflated()) {
            VoxelShape voxelshape;
            BlockPos blockpos = this.func_233580_cy_();
            BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (!(blockstate.isAir((IBlockReader)this.field_70170_p, blockpos) || this.field_70145_X || (voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b())) {
                for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                    if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(this.func_213303_ch())) continue;
                    this.stuckInBlock = true;
                    break;
                }
            }
            if (this.stuckInBlock && !this.field_70145_X) {
                if (!this.field_70170_p.field_72995_K && this.stuckInBlockState != blockstate && this.field_70170_p.func_226664_a_(this.func_174813_aQ().func_186662_g(0.06))) {
                    this.disableProjectile();
                }
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.0, 1.0, 0.0));
            } else {
                Vector3d positionVec = new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                Vector3d endVec = positionVec.func_178787_e(motion);
                BlockRayTraceResult traceResult = this.field_70170_p.func_217299_a(new RayTraceContext(positionVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
                EntityRayTraceResult entityTraceResult = this.traceEntity(positionVec, endVec);
                if (entityTraceResult != null) {
                    traceResult = entityTraceResult;
                }
                if (traceResult.func_216346_c() != RayTraceResult.Type.MISS) {
                    this.onSting((RayTraceResult)traceResult);
                    this.field_70160_al = true;
                }
            }
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        ItemStack newStackToCreate;
        CompoundNBT stackToCreate;
        super.func_70037_a(compound);
        this.setAttachedHiveSide(Direction.func_82600_a((int)compound.func_74771_c("AttachedHiveSide")));
        this.setFromBottle(compound.func_74767_n("FromBottle"));
        this.teleportCooldown = compound.func_74762_e("TeleportCooldown");
        this.ticksAwayFromHive = compound.func_74762_e("TicksAwayFromHive");
        if (compound.func_74764_b("IsInflated")) {
            this.setInflated(compound.func_74767_n("IsInflated"));
        }
        if (compound.func_150297_b("HivePos", 10)) {
            this.setHivePos(NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("HivePos")));
        }
        if (compound.func_150297_b("StuckInBlockState", 10)) {
            this.stuckInBlockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("StuckInBlockState"));
        }
        if ((stackToCreate = compound.func_74775_l("ItemStackToCreate")) != null && !(newStackToCreate = ItemStack.func_199557_a((CompoundNBT)stackToCreate)).func_190926_b()) {
            this.setStackToCreate(newStackToCreate);
        }
        this.rotationController = this.getRotationController().read(this, compound.func_74775_l("Orientation"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("AttachedHiveSide", (byte)this.getAttachedHiveSide().func_176745_a());
        compound.func_74757_a("FromBottle", this.isFromBottle());
        compound.func_74757_a("IsInflated", this.isInflated());
        compound.func_74768_a("TeleportCooldown", this.teleportCooldown);
        compound.func_74768_a("TicksAwayFromHive", this.ticksAwayFromHive);
        if (this.getHivePos() != null) {
            compound.func_218657_a("HivePos", (INBT)NBTUtil.func_186859_a((BlockPos)this.getHivePos()));
        }
        if (this.hasStackToCreate()) {
            compound.func_218657_a("ItemStackToCreate", (INBT)this.getStackToCreate().func_77955_b(new CompoundNBT()));
        }
        if (this.stuckInBlockState != null) {
            compound.func_218657_a("StuckInBlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.stuckInBlockState));
        }
        compound.func_218657_a("Orientation", (INBT)this.getRotationController().write(new CompoundNBT()));
    }

    @Nullable
    public BlockPos getHivePos() {
        return ((Optional)this.func_184212_Q().func_187225_a(HIVE_POS)).orElse(null);
    }

    public void setHivePos(@Nullable BlockPos pos) {
        this.func_184212_Q().func_187227_b(HIVE_POS, Optional.ofNullable(pos));
    }

    @Nullable
    public PuffBugHiveTileEntity getHive() {
        BlockPos hivePos = this.getHivePos();
        if (hivePos != null) {
            try {
                TileEntity tileEntity = this.field_70170_p.func_175625_s(hivePos).getTileEntity();
                if (tileEntity instanceof PuffBugHiveTileEntity) {
                    return (PuffBugHiveTileEntity)tileEntity;
                }
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos getBudPos() {
        return this.budPos;
    }

    public void setBudPos(@Nullable BlockPos pos) {
        this.budPos = pos;
    }

    @Nullable
    public BlockPos getPollinationPos() {
        return this.pollinationPos;
    }

    public void setPollinationPos(@Nullable BlockPos pos) {
        this.pollinationPos = pos;
    }

    public boolean canAttachToSide(Direction direction) {
        if (direction == Direction.UP) {
            return false;
        }
        return this.getHive() != null && PuffBugHiveTileEntity.HiveOccupantData.isHiveSideEmpty(this.getHive(), direction);
    }

    public Direction getAttachedHiveSide() {
        return (Direction)this.field_70180_af.func_187225_a(ATTACHED_HIVE_SIDE);
    }

    public void setAttachedHiveSide(Direction side) {
        this.field_70180_af.func_187227_b(ATTACHED_HIVE_SIDE, (Object)side);
    }

    @Nullable
    public Direction getTeleportHiveSide() {
        return this.teleportHiveSide;
    }

    public void setTeleportHiveSide(@Nullable Direction side) {
        this.teleportHiveSide = side;
    }

    @Nullable
    public Direction getDesiredHiveSide() {
        return this.desiredHiveSide;
    }

    public void setDesiredHiveSide(@Nullable Direction side) {
        this.desiredHiveSide = side;
    }

    public boolean isFromBottle() {
        return (Boolean)this.field_70180_af.func_187225_a(FROM_BOTTLE);
    }

    public void setFromBottle(boolean value) {
        this.field_70180_af.func_187227_b(FROM_BOTTLE, (Object)value);
    }

    public boolean isInflated() {
        return (Boolean)this.field_70180_af.func_187225_a(INFLATED);
    }

    public void setInflated(boolean inflated) {
        this.field_70180_af.func_187227_b(INFLATED, (Object)inflated);
    }

    public boolean isBoosting() {
        return (Boolean)this.field_70180_af.func_187225_a(BOOSTING);
    }

    public void setBoosting(boolean boosting) {
        this.field_70180_af.func_187227_b(BOOSTING, (Object)boosting);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public void setStackToCreate(@Nullable ItemStack stack) {
        this.stackToCreate = stack;
    }

    @Nullable
    public ItemStack getStackToCreate() {
        return this.stackToCreate;
    }

    public boolean hasStackToCreate() {
        return this.getStackToCreate() != null;
    }

    public void setLaunchDirection(float pitch, float yaw) {
        this.field_70180_af.func_187227_b(LAUNCH_DIRECTION, Optional.of(new Vector3d((double)pitch, (double)yaw, 0.0)));
    }

    public void setFireDirection(float pitch, float yaw) {
        this.field_70180_af.func_187227_b(FIRE_DIRECTION, Optional.of(new Vector3d((double)pitch, (double)yaw, 0.0)));
    }

    public void removeLaunchDirection() {
        this.field_70180_af.func_187227_b(LAUNCH_DIRECTION, Optional.empty());
    }

    public void removeFireDirection() {
        this.field_70180_af.func_187227_b(FIRE_DIRECTION, Optional.empty());
    }

    @Nullable
    public Vector3d getLaunchDirection() {
        return ((Optional)this.field_70180_af.func_187225_a(LAUNCH_DIRECTION)).orElse(null);
    }

    @Nullable
    public Vector3d getFireDirection() {
        return ((Optional)this.field_70180_af.func_187225_a(FIRE_DIRECTION)).orElse(null);
    }

    public boolean hasLevitation() {
        return this.func_70644_a(Effects.field_188424_y);
    }

    public boolean func_189652_ae() {
        return super.func_189652_ae() || this.getAttachedHiveSide() != Direction.UP;
    }

    public TeleportController getTeleportController() {
        return this.teleportController;
    }

    public RotationController getRotationController() {
        return this.rotationController;
    }

    public Endimation[] getEndimations() {
        return new Endimation[]{CLAIM_HIVE_ANIMATION, PUFF_ANIMATION, TELEPORT_TO_ANIMATION, TELEPORT_FROM_ANIMATION, ROTATE_ANIMATION, POLLINATE_ANIMATION, MAKE_ITEM_ANIMATION, FLY_ANIMATION, LAND_ANIMATION, PULL_ANIMATION};
    }

    public void onEndimationStart(Endimation endimation) {
        if (endimation == PUFF_ANIMATION) {
            float pitch = this.func_184207_aI() ? 1.0f : this.field_70125_A;
            float xMotion = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
            float zMotion = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
            Vector3d motion = new Vector3d((double)xMotion, (double)0.65f, (double)zMotion).func_72432_b();
            if (this.func_70638_az() != null && CAN_ANGER.test(this.func_70638_az())) {
                motion.func_186678_a(2.0);
            }
            this.func_70024_g(motion.func_82615_a() * (this.func_110148_a(Attributes.field_233821_d_).func_111126_e() - (double)0.1f), motion.func_82617_b(), motion.func_82616_c() * (this.func_110148_a(Attributes.field_233821_d_).func_111126_e() - (double)0.1f));
        } else if (endimation == TELEPORT_TO_ANIMATION) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(this.getTeleportSound(false), 0.65f, this.func_70647_i());
            }
        } else if (endimation == FLY_ANIMATION) {
            this.field_70170_p.func_217384_a(null, (Entity)this, (SoundEvent)EESounds.PUFFBUG_LAUNCH.get(), SoundCategory.HOSTILE, 0.25f, this.func_70681_au().nextFloat() * 0.35f + 0.75f);
        }
    }

    public void onEndimationEnd(Endimation endimation) {
        if (endimation == TELEPORT_TO_ANIMATION) {
            if (!this.field_70170_p.field_72995_K) {
                NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)TELEPORT_FROM_ANIMATION);
                this.func_184185_a(this.getTeleportSound(true), 0.65f, this.func_70647_i());
            }
        } else if (endimation == POLLINATE_ANIMATION) {
            BolloomBudTileEntity bud;
            TileEntity te;
            this.func_195064_c(new EffectInstance(Effects.field_188424_y, 3000));
            if (this.getPollinationPos() != null && (te = this.field_70170_p.func_175625_s(this.getPollinationPos())) instanceof BolloomBudTileEntity && (bud = (BolloomBudTileEntity)te).canBeOpened()) {
                for (BolloomBudTileEntity.BudSide side : BolloomBudTileEntity.BudSide.values()) {
                    BlockPos sidePos = side.offsetPosition(this.getPollinationPos());
                    if (!this.field_70170_p.func_180495_p(sidePos).func_196952_d((IBlockReader)this.field_70170_p, this.getPollinationPos()).func_197766_b()) continue;
                    this.field_70170_p.func_175655_b(sidePos, true);
                }
                this.field_70170_p.func_175656_a(this.getPollinationPos(), (BlockState)this.field_70170_p.func_180495_p(this.getPollinationPos()).func_206870_a((Property)BolloomBudBlock.OPENED, (Comparable)Boolean.valueOf(true)));
                bud.startGrowing(this.func_70681_au(), bud.calculateFruitMaxHeight(), false);
            }
        }
    }

    public void func_213352_e(Vector3d moveDirection) {
        if (this.func_70613_aW() && this.isInflated()) {
            double gravity = this.hasLevitation() ? -0.005 : 0.005;
            float speed = this.field_70122_E ? 0.01f : 0.025f;
            this.func_213309_a(speed, moveDirection);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.75));
            this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, gravity, 0.0));
        } else {
            boolean noVerticalMotion;
            if (this.stuckInBlock) {
                this.func_213293_j(0.0, this.func_213322_ci().func_82617_b(), 0.0);
            }
            boolean bl = noVerticalMotion = this.isInflated() && (this.getAttachedHiveSide() != Direction.UP || this.getDesiredHiveSide() != null);
            if (noVerticalMotion) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            }
            super.func_213352_e(Vector3d.field_186680_a);
            if (noVerticalMotion) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            }
            if (this.isProjectile()) {
                this.func_213317_d(this.func_213322_ci().func_178786_a(0.0, (double)0.005f, 0.0));
            }
            if (this.stuckInBlock) {
                this.func_213293_j(0.0, this.func_213322_ci().func_82617_b(), 0.0);
            }
        }
    }

    public void addToHive(PuffBugHiveTileEntity hive) {
        hive.addBugToHive(this);
        this.setHivePos(hive.func_174877_v());
    }

    @Nullable
    public PuffBugHiveTileEntity findNewNearbyHive() {
        BlockPos pos = this.func_233580_cy_();
        double xyDistance = 16.0;
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177963_a(-xyDistance, -6.0, -xyDistance), (BlockPos)pos.func_177963_a(xyDistance, 6.0, xyDistance))) {
            PuffBugHiveTileEntity hive;
            if (!blockpos.func_218137_a((IPosition)this.func_213303_ch(), xyDistance) || this.field_70170_p.func_180495_p(blockpos).func_177230_c() != EEBlocks.PUFFBUG_HIVE.get() || !(this.field_70170_p.func_175625_s(blockpos) instanceof PuffBugHiveTileEntity) || (hive = (PuffBugHiveTileEntity)this.field_70170_p.func_175625_s(blockpos)).isHiveFull() || this.getHive() != null) continue;
            return hive;
        }
        return null;
    }

    protected void setBottleData(ItemStack bottle) {
        if (this.func_145818_k_()) {
            bottle.func_200302_a(this.func_200201_e());
        }
        CompoundNBT nbt = bottle.func_196082_o();
        if (this.getColor() != -1) {
            nbt.func_74768_a("ColorTag", this.getColor());
        }
        nbt.func_74768_a("TeleportCooldown", this.teleportCooldown);
        if (!this.func_70651_bq().isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (EffectInstance effectinstance : this.func_70651_bq()) {
                listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
            }
            nbt.func_218657_a("CustomPotionEffects", (INBT)listnbt);
        }
        nbt.func_74757_a("IsFromBottle", true);
        nbt.func_74757_a("IsChild", this.func_70631_g_());
    }

    private void keepEffectsAbsorbed() {
        for (Effect effect : this.func_193076_bZ().keySet()) {
            if (effect == Effects.field_188424_y) continue;
            EffectInstance effectInstance = (EffectInstance)this.func_193076_bZ().get(effect);
            this.func_193076_bZ().put(effect, new EffectInstance(effect, 1600, effectInstance.func_76458_c(), effectInstance.func_82720_e(), effectInstance.func_188418_e()));
        }
    }

    public void tryToTeleportToHive(BlockPos pos) {
        BlockPos.Mutable positions = new BlockPos.Mutable();
        ArrayList avaliablePositions = Lists.newArrayList();
        PuffBugHiveTileEntity hive = this.getHive();
        if (hive == null || hive != null && !hive.canTeleportTo() || this.getAttachedHiveSide() == Direction.UP && Math.sqrt(this.func_195048_a(Vector3d.func_237489_a_((Vector3i)pos))) < 5.0 || this.isEndimationPlaying(TELEPORT_FROM_ANIMATION)) {
            return;
        }
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 6; ++y) {
                for (int z = 0; z < 6; ++z) {
                    positions.func_189533_g((Vector3i)pos.func_177982_a(x, y, z));
                    if (!this.field_70170_p.func_175623_d((BlockPos)positions)) continue;
                    avaliablePositions.add(new BlockPos((Vector3i)positions));
                }
            }
        }
        if (!avaliablePositions.isEmpty() && !this.isProjectile()) {
            this.getTeleportController().destination = GenerationUtils.getClosestPositionToPos(avaliablePositions, this.func_233580_cy_());
            this.func_70661_as().func_75499_g();
            if (!this.isEndimationPlaying(TELEPORT_TO_ANIMATION)) {
                this.getTeleportController().processTeleportation();
            }
        }
    }

    private void onSting(RayTraceResult result) {
        RayTraceResult.Type resultType = result.func_216346_c();
        if (resultType == RayTraceResult.Type.ENTITY) {
            EntityRayTraceResult entityResult = (EntityRayTraceResult)result;
            Entity entity = entityResult.func_216348_a();
            if (entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_76349_b(), (float)this.func_110148_a(Attributes.field_233823_f_).func_111126_e())) {
                this.setInflated(true);
                this.removeFireDirection();
                this.stuckInBlock = false;
                if (!this.func_70651_bq().isEmpty() && entity instanceof LivingEntity) {
                    for (EffectInstance effects : this.func_70651_bq()) {
                        ((LivingEntity)entity).func_195064_c(effects);
                    }
                    this.func_195061_cb();
                }
            }
        } else {
            BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)result;
            this.stuckInBlockState = this.field_70170_p.func_180495_p(blockraytraceresult.func_216350_a());
            this.stuckInBlock = true;
            Vector3d end = result.func_216347_e();
            this.func_70107_b(end.func_82615_a(), end.func_82617_b(), end.func_82616_c());
            this.func_213317_d(Vector3d.field_186680_a);
            if (!this.field_70170_p.field_72995_K) {
                NetworkUtil.setPlayingAnimationMessage((Entity)this, (Endimation)LAND_ANIMATION);
            }
            this.field_70170_p.func_217384_a(null, (Entity)this, (SoundEvent)EESounds.PUFFBUG_LAND.get(), SoundCategory.HOSTILE, 0.5f, this.func_70647_i());
        }
    }

    @Nullable
    private EntityRayTraceResult traceEntity(Vector3d start, Vector3d end) {
        return ProjectileHelper.func_221269_a((World)this.field_70170_p, (Entity)this, (Vector3d)start, (Vector3d)end, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(0.5), result -> !result.func_175149_v() && result.func_70089_S() && !(result instanceof PuffBugEntity));
    }

    public void disableProjectile() {
        this.stuckInBlock = false;
        this.setInflated(true);
        this.removeFireDirection();
        this.field_70170_p.func_72960_a((Entity)this, (byte)38);
    }

    public boolean wantsToRest() {
        return this.ticksAwayFromHive >= 3000;
    }

    public boolean isProjectile() {
        return this.getFireDirection() != null || this.getLaunchDirection() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAtCorrectRestLocation(Direction side) {
        TileEntity te;
        TileEntity tileEntity = side == Direction.DOWN ? (this.func_70631_g_() ? this.field_70170_p.func_175625_s(this.func_233580_cy_().func_177981_b(1)) : this.field_70170_p.func_175625_s(this.func_233580_cy_().func_177981_b(2))) : (te = this.func_70631_g_() ? this.field_70170_p.func_175625_s(this.func_233580_cy_().func_177972_a(side.func_176734_d())) : this.field_70170_p.func_175625_s(this.func_233580_cy_().func_177981_b(1).func_177972_a(side.func_176734_d())));
        if (te != this.getHive()) {
            return false;
        }
        BlockPos hivePos = this.getHivePos();
        switch (side) {
            case UP: {
                return false;
            }
            case DOWN: {
                float yOffsetDown = this.func_70631_g_() ? 0.45f : -0.15f;
                if (!(Vector3d.func_237489_a_((Vector3i)hivePos.func_177977_b().func_177963_a(0.5, (double)yOffsetDown, 0.5)).func_72438_d(this.func_213303_ch()) < 0.25)) return false;
                return true;
            }
        }
        float yOffset = this.func_70631_g_() ? 0.2f : -0.2f;
        BlockPos sideOffset = hivePos.func_177972_a(side);
        if (!this.field_70170_p.func_175623_d(sideOffset.func_177984_a())) return false;
        if (!this.field_70170_p.func_175623_d(sideOffset.func_177977_b())) return false;
        double d = Vector3d.func_237491_b_((Vector3i)sideOffset).func_72441_c((double)this.getTeleportController().getOffsetForDirection(side)[0], (double)yOffset, (double)this.getTeleportController().getOffsetForDirection(side)[1]).func_72438_d(this.func_213303_ch());
        float f = this.func_70631_g_() ? 0.1f : 0.25f;
        if (!(d < (double)f)) return false;
        return true;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new EndergeticFlyingPathNavigator((MobEntity)this, worldIn);
    }

    public boolean func_213743_em() {
        return super.func_213743_em() && this.isInflated();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 38) {
            this.stuckInBlock = false;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double boundingBoxLength = this.func_174813_aQ().func_72320_b() * 2.5;
        if (Double.isNaN(boundingBoxLength)) {
            boundingBoxLength = 1.0;
        }
        return distance < (boundingBoxLength = boundingBoxLength * 64.0 * PuffBugEntity.func_184183_bd()) * boundingBoxLength;
    }

    public float func_70013_c() {
        BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_70047_e(), this.func_226281_cx_());
        if (this.stuckInBlock && !this.isInflated()) {
            Direction verticalOffset;
            boolean rotationFlag = true;
            float[] rotations = this.getRotationController().getRotations(1.0f);
            Direction horizontalOffset = Direction.func_176733_a((double)rotations[0]).func_176734_d();
            Direction direction = verticalOffset = rotations[1] <= 180.0f && rotations[1] > 100.0f ? Direction.UP : Direction.DOWN;
            if (rotations[1] >= 80.0f && rotations[1] <= 100.0f) {
                rotationFlag = false;
            }
            return this.field_70170_p.isAreaLoaded(blockpos, 0) ? (float)this.field_70170_p.func_201696_r(rotationFlag ? blockpos.func_177972_a(horizontalOffset).func_177972_a(verticalOffset) : blockpos.func_177972_a(horizontalOffset)) : 0.0f;
        }
        return super.func_70013_c();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize size) {
        return this.isProjectile() ? 0.0f : size.field_220316_b * 0.5f;
    }

    protected void func_175135_B() {
        super.func_175135_B();
        Collection effects = this.func_70651_bq();
        if (!effects.isEmpty()) {
            this.setColor(PotionUtils.func_185181_a((Collection)effects));
        } else {
            this.setColor(-1);
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)EEItems.PUFF_BUG_SPAWN_EGG.get());
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ((Block)EEBlocks.TALL_POISE_BUSH.get()).func_199767_j();
    }

    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl().func_186662_g(12.0);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (!this.func_70089_S() || this.func_213398_dR()) {
            return ActionResultType.FAIL;
        }
        if (item == Items.field_151069_bo) {
            this.func_184185_a(SoundEvents.field_187618_I, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack bottle = new ItemStack((IItemProvider)EEItems.PUFFBUG_BOTTLE.get());
            this.setBottleData(bottle);
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, bottle);
            } else if (!player.field_71071_by.func_70441_a(bottle)) {
                player.func_71019_a(bottle, false);
            }
            this.func_70106_y();
            return ActionResultType.SUCCESS;
        }
        if (!this.hasStackToCreate() && this.hasLevitation()) {
            ItemStack newStackToCreate;
            Object object = item == EEItems.BOLLOOM_FRUIT.get() ? new ItemStack((IItemProvider)EEBlocks.BOLLOOM_BUD.get()) : (newStackToCreate = this.func_70877_b(itemstack) ? new ItemStack((IItemProvider)EEBlocks.PUFFBUG_HIVE.get()) : null);
            if (newStackToCreate != null) {
                this.setStackToCreate(newStackToCreate);
                this.func_175505_a(player, itemstack);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            return ActionResultType.PASS;
        }
        return super.func_230254_b_(player, hand);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random rng = this.func_70681_au();
        if (dataTag != null) {
            int age = dataTag.func_74767_n("IsChild") ? -24000 : 0;
            this.func_70873_a(age);
            this.teleportCooldown = dataTag.func_74762_e("TeleportCooldown");
            this.setFromBottle(dataTag.func_74767_n("IsFromBottle"));
            if (dataTag.func_150297_b("ColorTag", 3)) {
                this.setColor(dataTag.func_74762_e("ColorTag"));
            }
            if (dataTag.func_74764_b("CustomPotionEffects")) {
                for (EffectInstance effectinstance : PotionUtils.func_185192_b((CompoundNBT)dataTag)) {
                    this.func_195064_c(effectinstance);
                }
            }
        }
        if (reason == SpawnReason.STRUCTURE) {
            this.ticksAwayFromHive = rng.nextInt(1500) + 1500;
            if (rng.nextFloat() < 0.1f) {
                this.field_175504_a = -24000;
            }
        } else if ((reason == SpawnReason.NATURAL || reason == SpawnReason.SPAWNER) && rng.nextFloat() < 0.05f) {
            int swarmSize = rng.nextInt(11) + 10;
            Vector3d centeredPos = Vector3d.func_237489_a_((Vector3i)this.func_233580_cy_());
            for (int i = 0; i < swarmSize; ++i) {
                Vector3d spawnPos = centeredPos.func_72441_c(MathUtil.makeNegativeRandomly((double)(rng.nextFloat() * 5.5f), (Random)rng), MathUtil.makeNegativeRandomly((double)(rng.nextFloat() * 2.0f), (Random)rng), MathUtil.makeNegativeRandomly((double)(rng.nextFloat() * 5.5f), (Random)rng));
                if (!this.field_70170_p.func_175623_d(new BlockPos(spawnPos))) continue;
                PuffBugEntity swarmChild = (PuffBugEntity)((EntityType)EEEntities.PUFF_BUG.get()).func_200721_a(this.field_70170_p);
                swarmChild.func_70012_b(spawnPos.func_82615_a(), spawnPos.func_82617_b(), spawnPos.func_82616_c(), 0.0f, 0.0f);
                swarmChild.func_213386_a(worldIn, this.field_70170_p.func_175649_E(new BlockPos(spawnPos)), SpawnReason.EVENT, null, null);
                swarmChild.func_70873_a(-24000);
                this.field_70170_p.func_217376_c((Entity)swarmChild);
            }
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.getHive() == null && !this.isFromBottle() && !this.func_145818_k_();
    }

    public boolean func_213392_I() {
        return this.isFromBottle();
    }

    protected void func_82167_n(Entity entity) {
        if (!this.isInflated() && !(entity instanceof PuffBugEntity) && this.isProjectile() && entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this).func_76349_b(), 5.0f)) {
            this.setInflated(true);
            this.removeFireDirection();
            this.stuckInBlock = false;
            if (!this.func_70651_bq().isEmpty() && entity instanceof LivingEntity) {
                for (EffectInstance effects : this.func_70651_bq()) {
                    ((LivingEntity)entity).func_195064_c(effects);
                }
                this.func_195061_cb();
            }
        }
        super.func_82167_n(entity);
    }

    public EntitySize func_213305_a(Pose pose) {
        return this.isProjectile() ? (this.func_70631_g_() ? PROJECTILE_SIZE_CHILD : PROJECTILE_SIZE) : super.func_213305_a(pose);
    }

    public boolean func_180431_b(DamageSource source) {
        return (this.isProjectile() || this.func_184218_aH()) && (source == DamageSource.field_76368_d || source == DamageSource.field_188406_j || source == DamageSource.field_191291_g) || super.func_180431_b(source);
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageableEntity) {
        return (AgeableEntity)((EntityType)EEEntities.PUFF_BUG.get()).func_200721_a(this.field_70170_p);
    }

    public SoundEvent getPuffSound() {
        return (SoundEvent)EESounds.PUFFBUG_PUFF.get();
    }

    public SoundEvent getTeleportSound(boolean from) {
        return from ? (SoundEvent)EESounds.PUFFBUG_TELEPORT_FROM.get() : (SoundEvent)EESounds.PUFFBUG_TELEPORT_TO.get();
    }

    public SoundEvent getSleepSound() {
        return (SoundEvent)EESounds.PUFFBUG_SLEEP.get();
    }

    public SoundEvent getItemCreationSound() {
        return (SoundEvent)EESounds.PUFFBUG_CREATE_ITEM.get();
    }

    public SoundEvent getLaunchSound() {
        return (SoundEvent)EESounds.PUFFBUG_LAUNCH.get();
    }

    public SoundEvent getLandSound() {
        return (SoundEvent)EESounds.PUFFBUG_LAND.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)EESounds.PUFFBUG_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return (SoundEvent)EESounds.PUFFBUG_HURT.get();
    }

    public Endimation getPlayingEndimation() {
        return this.endimation;
    }

    public void setPlayingEndimation(Endimation endimationToPlay) {
        this.endimation = endimationToPlay;
        this.setAnimationTick(0);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int animationTick) {
        this.animationTick = animationTick;
    }

    public static class RotationController {
        private PuffBugEntity puffbug;
        private float prevYaw;
        private float yaw;
        private float startingYaw;
        private float prevPitch;
        private float pitch;
        private float startingPitch;
        private float setYaw;
        private float setPitch;
        private int tickLength;
        private int ticksSinceNotRotating;
        public boolean rotating;

        RotationController(PuffBugEntity puffbug) {
            this.puffbug = puffbug;
        }

        protected void tick() {
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            if (!this.rotating) {
                ++this.ticksSinceNotRotating;
                if (this.ticksSinceNotRotating > 5) {
                    if (this.setYaw != 0.0f) {
                        this.startingYaw = this.yaw;
                    }
                    if (this.setPitch != 0.0f) {
                        this.startingPitch = this.pitch;
                        if (this.puffbug.isNoEndimationPlaying()) {
                            NetworkUtil.setPlayingAnimationMessage((Entity)this.puffbug, (Endimation)ROTATE_ANIMATION);
                        }
                    }
                    this.setYaw = 0.0f;
                    this.setPitch = 0.0f;
                    this.tickLength = this.puffbug.func_184218_aH() ? 1 : 20;
                }
            }
            this.yaw = this.clamp(this.setYaw - this.startingYaw <= 0.0f, this.yaw + (this.setYaw - this.startingYaw) / (float)this.tickLength, this.startingYaw, this.setYaw);
            this.pitch = this.clamp(this.setPitch - this.startingPitch <= 0.0f, this.pitch + (this.setPitch - this.startingPitch) / (float)this.tickLength, this.startingPitch, this.setPitch);
            this.rotating = false;
        }

        private float clamp(boolean invert, float num, float min, float max) {
            if (invert) {
                return num > max ? num : max;
            }
            if (num < min) {
                return min;
            }
            return num > max ? max : num;
        }

        public void rotate(float yaw, float pitch, float roll, int tickLength) {
            if (this.setYaw != yaw) {
                this.startingYaw = this.yaw;
            }
            if (this.setPitch != pitch) {
                this.startingPitch = this.pitch;
                if (tickLength >= 20 && this.puffbug.isNoEndimationPlaying()) {
                    NetworkUtil.setPlayingAnimationMessage((Entity)this.puffbug, (Endimation)ROTATE_ANIMATION);
                }
            }
            this.setYaw = yaw;
            this.setPitch = pitch;
            this.tickLength = tickLength;
            this.rotating = true;
            this.ticksSinceNotRotating = 0;
            if (!this.puffbug.field_70170_p.field_72995_K) {
                EndergeticExpansion.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this.puffbug), (Object)new RotateMessage(this.puffbug.func_145782_y(), tickLength, yaw, pitch, roll));
            }
        }

        protected CompoundNBT write(CompoundNBT compound) {
            compound.func_74776_a("Yaw", this.yaw);
            compound.func_74776_a("Pitch", this.pitch);
            compound.func_74776_a("SetYaw", this.setYaw);
            compound.func_74776_a("SetPitch", this.setPitch);
            compound.func_74776_a("StartingYaw", this.startingYaw);
            compound.func_74776_a("StartingPitch", this.startingPitch);
            compound.func_74768_a("TickLength", this.tickLength);
            compound.func_74757_a("Rotating", this.rotating);
            return compound;
        }

        protected RotationController read(PuffBugEntity puffbug, CompoundNBT compound) {
            RotationController rotationController = new RotationController(puffbug);
            rotationController.yaw = rotationController.prevYaw = compound.func_74760_g("Yaw");
            rotationController.pitch = rotationController.prevPitch = compound.func_74760_g("Pitch");
            rotationController.setYaw = compound.func_74760_g("SetYaw");
            rotationController.setPitch = compound.func_74760_g("SetPitch");
            rotationController.startingYaw = compound.func_74760_g("StartingYaw");
            rotationController.startingPitch = compound.func_74760_g("StartingPitch");
            rotationController.tickLength = compound.func_74762_e("TickLength");
            rotationController.rotating = compound.func_74767_n("Rotating");
            return rotationController;
        }

        public float[] getRotations(float ptc) {
            return new float[]{MathHelper.func_219799_g((float)ptc, (float)this.prevYaw, (float)this.yaw), MathHelper.func_219799_g((float)ptc, (float)this.prevPitch, (float)this.pitch)};
        }
    }

    public static class TeleportController {
        private PuffBugEntity puffbug;
        private World world;
        @Nullable
        private BlockPos destination;

        TeleportController(PuffBugEntity puffbug) {
            this.puffbug = puffbug;
            this.world = puffbug.field_70170_p;
        }

        public void processTeleportation() {
            if (!this.hasNoDestination() && !this.world.field_72995_K) {
                this.puffbug.func_70661_as().func_75499_g();
                NetworkUtil.setPlayingAnimationMessage((Entity)this.puffbug, (Endimation)TELEPORT_TO_ANIMATION);
                this.puffbug.teleportCooldown = this.puffbug.func_70681_au().nextInt(300) + 1200;
            }
        }

        protected void bringToDestination() {
            if (!this.world.field_72995_K) {
                float zOffset;
                float xOffset;
                Direction side = this.puffbug.getTeleportHiveSide();
                float f = xOffset = side == null || side == Direction.DOWN ? 0.5f : this.getOffsetForDirection(side)[0];
                float yOffset = side == Direction.DOWN ? (this.puffbug.func_70631_g_() ? 0.45f : -0.15f) : (this.puffbug.func_70631_g_() ? 0.2f : -0.2f);
                float f2 = zOffset = side == null || side == Direction.DOWN ? 0.5f : this.getOffsetForDirection(side)[1];
                if (side == null) {
                    NetworkUtil.teleportEntity((Entity)this.puffbug, (double)((float)this.destination.func_177958_n() + 0.5f), (double)((float)this.destination.func_177956_o() + 0.5f), (double)((float)this.destination.func_177952_p() + 0.5f));
                } else {
                    NetworkUtil.teleportEntity((Entity)this.puffbug, (double)((float)this.destination.func_177958_n() + xOffset), (double)((float)this.destination.func_177956_o() + yOffset), (double)((float)this.destination.func_177952_p() + zOffset));
                }
                this.destination = null;
                this.puffbug.func_70661_as().func_75499_g();
                this.puffbug.func_213317_d(Vector3d.field_186680_a);
                if (side != null) {
                    this.puffbug.setDesiredHiveSide(side);
                    this.puffbug.setTeleportHiveSide(null);
                }
            }
        }

        @Nullable
        public boolean tryToCreateDesinationTo(BlockPos pos, @Nullable Direction direction) {
            boolean directionFlag;
            boolean bl = directionFlag = direction != null ? this.world.func_175623_d(pos.func_177972_a(direction)) : true;
            if (!(direction == null || direction == Direction.DOWN || this.world.func_175623_d(pos.func_177984_a()) && this.world.func_175623_d(pos.func_177977_b()))) {
                directionFlag = false;
            }
            if (this.puffbug.field_70173_aa > 5 && this.world.func_175623_d(pos) && directionFlag && this.hasNoDestination() && this.world.func_217357_a(Entity.class, new AxisAlignedBB(pos)).isEmpty()) {
                this.destination = pos;
                return true;
            }
            return false;
        }

        public boolean hasNoDestination() {
            return this.destination == null;
        }

        public boolean canTeleport() {
            return this.destination == null && this.puffbug.teleportCooldown <= 0;
        }

        protected float[] getOffsetForDirection(Direction side) {
            float[] fArray;
            switch (side) {
                default: {
                    float[] fArray2;
                    if (this.puffbug.func_70631_g_()) {
                        float[] fArray3 = new float[2];
                        fArray3[0] = 0.5f;
                        fArray2 = fArray3;
                        fArray3[1] = 0.85f;
                    } else {
                        float[] fArray4 = new float[2];
                        fArray4[0] = 0.5f;
                        fArray2 = fArray4;
                        fArray4[1] = 0.75f;
                    }
                    return fArray2;
                }
                case SOUTH: {
                    float[] fArray5;
                    if (this.puffbug.func_70631_g_()) {
                        float[] fArray6 = new float[2];
                        fArray6[0] = 0.5f;
                        fArray5 = fArray6;
                        fArray6[1] = 0.15f;
                    } else {
                        float[] fArray7 = new float[2];
                        fArray7[0] = 0.5f;
                        fArray5 = fArray7;
                        fArray7[1] = 0.25f;
                    }
                    return fArray5;
                }
                case EAST: {
                    float[] fArray8;
                    if (this.puffbug.func_70631_g_()) {
                        float[] fArray9 = new float[2];
                        fArray9[0] = 0.15f;
                        fArray8 = fArray9;
                        fArray9[1] = 0.5f;
                    } else {
                        float[] fArray10 = new float[2];
                        fArray10[0] = 0.25f;
                        fArray8 = fArray10;
                        fArray10[1] = 0.5f;
                    }
                    return fArray8;
                }
                case WEST: 
            }
            if (this.puffbug.func_70631_g_()) {
                float[] fArray11 = new float[2];
                fArray11[0] = 0.85f;
                fArray = fArray11;
                fArray11[1] = 0.5f;
            } else {
                float[] fArray12 = new float[2];
                fArray12[0] = 0.75f;
                fArray = fArray12;
                fArray12[1] = 0.5f;
            }
            return fArray;
        }
    }

    static class PuffBugMoveController
    extends MovementController {
        private final PuffBugEntity puffbug;

        PuffBugMoveController(PuffBugEntity puffbug) {
            super((MobEntity)puffbug);
            this.puffbug = puffbug;
        }

        public void func_75641_c() {
            if (!this.puffbug.isInflated()) {
                this.puffbug.func_70659_e(0.0f);
                return;
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.puffbug.func_70661_as().func_75500_f()) {
                double xDistance = this.field_75646_b - this.puffbug.func_226277_ct_();
                double yDistance = this.field_75647_c - this.puffbug.func_226278_cu_();
                double zDistance = this.field_75644_d - this.puffbug.func_226281_cx_();
                double totalDistance = MathHelper.func_76133_a((double)(xDistance * xDistance + yDistance * yDistance + zDistance * zDistance));
                double verticalVelocity = yDistance / totalDistance;
                float angle = (float)(MathHelper.func_181159_b((double)zDistance, (double)xDistance) * 57.29577951308232) - 90.0f;
                this.puffbug.field_70761_aq = this.puffbug.field_70177_z = this.func_75639_a(this.puffbug.field_70177_z, angle, 20.0f);
                float speed = (float)(this.field_75645_e * this.puffbug.func_110148_a(Attributes.field_233822_e_).func_111126_e());
                if (verticalVelocity < 0.0) {
                    this.puffbug.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.puffbug.func_70689_ay(), (float)speed));
                    this.puffbug.func_213317_d(this.puffbug.func_213322_ci().func_72441_c(0.0, (double)this.puffbug.func_70689_ay() * verticalVelocity * 0.05, 0.0));
                    this.puffbug.setBoosting(false);
                } else {
                    this.puffbug.setBoosting(true);
                }
            } else {
                this.puffbug.func_70659_e(0.0f);
                this.puffbug.setBoosting(false);
            }
        }
    }
}

